<?php
namespace Newland\Toubiz\Poi\Neos\Filter\Items;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\NeosFiltering\Items\CheckboxList;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

class CityList extends CheckboxList
{
    /**
     * @var ArticleRepository
     * @Flow\Inject()
     */
    protected $articleRepository;

    public function setCombine(string $combine): void
    {
        if ($combine === static::$AND) {
            throw new \InvalidArgumentException('This filter item does not support being combined with AND');
        }
        parent::setCombine($combine);
    }

    protected function getStateValuesForQuery(): array
    {
        $identifiers = parent::getStateValues();

        if (empty($identifiers)) {
            return [];
        }
        $cityIds = [];
        foreach ($this->articleRepository->findByIdentifiers($identifiers) as $article) {
            $cityIds[] = $article->getPersistenceObjectIdentifier();
        }
        return $cityIds;
    }
}
