<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\IntegrationTestCase;
use Newland\Toubiz\Poi\Neos\Service\OutdoorActiveCredentialsService;

class OutdoorActiveCredentialsServiceTest extends IntegrationTestCase
{

    /** @var OutdoorActiveCredentialsService */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(OutdoorActiveCredentialsService::class);
    }

    public function testGetsSpecificApiKeyFromConfiguration(): void
    {
        $config = [
            'default' => [  'apiKey' => '__DEFAULT_API_KEY__', 'client' => '__DEFAULT_CLIENT__' ],
            'sites' => [ $this->site->getNodeName() => [  'apiKey' => '__SPECIFIC_API_KEY__', 'client' => '__SPECIFIC_CLIENT__' ] ],
        ];
        $this->withMockedConfiguration(
            [ 'Newland.Toubiz.Poi.Neos.outdoorActiveConfigurations' => $config ],
            function() {
                $credentials = $this->subject->getOutdoorActiveConfiguration($this->node);
                $this->assertEquals('__SPECIFIC_API_KEY__', $credentials['apiKey']);
                $this->assertEquals('__SPECIFIC_CLIENT__', $credentials['client']);
            }
        );
    }

    public function testGetsDefaultApiKeyFromConfiguration(): void
    {
        $config = [
            'default' => [  'apiKey' => '__DEFAULT_API_KEY__', 'client' => '__DEFAULT_CLIENT__' ],
        ];
        $this->withMockedConfiguration(
            [ 'Newland.Toubiz.Poi.Neos.outdoorActiveConfigurations' => $config ],
            function() {
                $credentials = $this->subject->getOutdoorActiveConfiguration($this->node);
                $this->assertEquals('__DEFAULT_API_KEY__', $credentials['apiKey']);
                $this->assertEquals('__DEFAULT_CLIENT__', $credentials['client']);
            }
        );
    }

}
