<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Teaser;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class TourTeaserTest extends TeaserTestCase
{

    protected function articleType(): int
    {
        return ArticleConstants::TYPE_TOUR;
    }

    public function testDisplaysStarClassificationOnTeaser(): void
    {
        $article = $this->article([ 'starClassifications' => [
            $this->starClassificationFactory->create([ 'value' => 3 ])
        ]]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseContains('<div class="tb-rating">', $response);
    }

    public function testDoesNotDisplayUnknownStarClassificationOnTeaser(): void
    {
        $article = $this->article([ 'starClassifications' => [
            $this->starClassificationFactory->create([ 'value' => -1 ])
        ]]);

        $this->node->setProperty('article', $article->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request((string) $this->nodeUri);

        $this->assertResponseOk($response);
        $this->assertResponseNotContains('<div class="tb-rating">', $response);
    }
}
