/**
 * Returns a component definition for an async component that displays a
 * loader while the real script is loading.
 *
 * @example
 * componets: {
 *      heavyComponent: asyncComponent(import('./heavy-component'))
 * }
 *
 * @param {Promise|Function<Promise>} promiseOrGetter
 * @returns {Function}
 */
export function asyncComponent(promiseOrGetter) {
    return () => {
        if (typeof promiseOrGetter === 'function') {
            promiseOrGetter = promiseOrGetter();
        }

        return {
            component: promiseOrGetter,
            loading: { template: '<div>loading</div>' }
        };
    };
}


export function loadVue() {
    const extractDefault = imported => imported.default;
    return Promise.all([
        import('vue').then(extractDefault),
        import('./mixins/remove-display-none.mixin').then(extractDefault),
        import('./mixins/language-labels.mixin').then(extractDefault),
    ]).then(([ Vue, removeDisplayNone, languageLabels ]) => {
        Vue.mixin(removeDisplayNone);
        Vue.mixin(languageLabels);

        // Used for Vue devtools
        window.Vue = Vue;

        return Vue;
    });
}
