<?php
namespace Newland\Toubiz\Poi\Neos\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Utility\Arrays;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists\EntityList;

class EntityListService
{
    public function getQuery(EntityList $entityList, ?Article $article, array $parameters): array
    {
        $query = [];

        $path = $parameters[$entityList->getType()] ?? null;
        if ($path) {
            $query = Arrays::setValueByPath($query, $path, $entityList->getIdentifiers());
        }

        if ($article && $article->getIsCity()) {
            $path = $parameters['city'] ?? 'city';
            $query = Arrays::setValueByPath($query, $path, $article->getPersistenceObjectIdentifier());
        }

        return (array) $query;
    }
}
