<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Teaser;

use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Tests\Factory\StarClassificationFactory;

abstract class TeaserTestCase extends IntegrationTestCase
{
    protected abstract function articleType(): int;

    /** @var StarClassificationFactory */
    protected $starClassificationFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->starClassificationFactory = new StarClassificationFactory($this->objectManager);
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Poi.Neos:Teaser'));
        $this->persistNode($this->node);
    }

    protected function article(array $attributes = []): Article
    {
        $attributes['mainType'] = $this->articleType();
        return $this->articleFactory->create($attributes);
    }
}
