<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Filter;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query;
use Newland\NeosFiltering\RangeSource\RangeSource;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;

class AttributeRangeSource implements RangeSource
{

    /** @var string */
    protected $name;

    /** @var int */
    protected $articleType;

    /** @var array */
    protected $bounds;

    /**
     * @var AttributeRepository
     * @Flow\Inject()
     */
    protected $attributeRepository;

    public function setArguments(array $arguments): void
    {
        $this->name = $arguments['name'];
        $this->articleType = $arguments['articleType'];
    }

    public function min(): ?float
    {
        return $this->bounds()['min'] ?? null;
    }

    public function max(): ?float
    {
        return $this->bounds()['max'] ?? null;
    }

    protected function bounds(): array
    {
        if ($this->bounds === null) {
            $this->bounds = $this->attributeRepository->getNumberBoundsForName($this->name, 10, $this->articleType);
        }
        return $this->bounds;
    }
}
