<?php declare(strict_types=1);


namespace Newland\Toubiz\Poi\Neos\Tests\Factory;


use Faker\Factory;
use Faker\Generator;
use Newland\Toubiz\Sync\Neos\Domain\Model\Address;

class AddressFactory
{

    public static function make(Generator $faker = null, array $properties = []): Address
    {
        $faker = $faker ?? Factory::create();

        $address = new Address();
        $address->setOriginalId($properties['originalId'] ?? $faker->uuid);
        $address->setName($properties['name'] ?? $faker->name);
        $address->setFirstName($properties['firstName'] ?? $faker->firstName);
        $address->setLastName($properties['lastName'] ?? $faker->lastName);
        $address->setLatitude($properties['latitude'] ?? $faker->latitude);
        $address->setLongitude($properties['longitude'] ?? $faker->longitude);
        $address->setStreet($properties['street'] ?? $faker->streetName);
        $address->setZip($properties['zip'] ?? $faker->postcode);
        $address->setCity($properties['city'] ?? $faker->city);
        $address->setCountry($properties['country'] ?? $faker->country);
        $address->setEmailAddress($properties['eMailAddress'] ?? $faker->email);
        $address->setPhoneNumber($properties['phoneNumber'] ?? $faker->phoneNumber);
        $address->setWebsiteAddress($properties['websiteAddress'] ?? $faker->url);
        return $address;
    }

}
