<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Filter;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\ObjectManagement\Exception\InvalidObjectException;
use Newland\NeosFiltering\Factory\DefaultFilterFactory;
use Newland\Toubiz\Poi\Neos\Filter\Items\ArticleRoot;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Poi\Neos\Filter\Items\AttributeCheckboxList;
use Newland\Toubiz\Poi\Neos\Filter\Items\AttributeRange;
use Newland\Toubiz\Poi\Neos\Filter\Items\PreselectedTags;

class ArticleFilterFactory extends DefaultFilterFactory
{

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="filter")
     */
    protected $settings;


    public function __construct(NodeInterface $node)
    {
        parent::__construct($node);
        $this->predefinedTypes['attribute_range'] = AttributeRange::class;
        $this->predefinedTypes['attribute_checkbox_list'] = AttributeCheckboxList::class;
        $this->predefinedTypes['preselected_tags'] = PreselectedTags::class;
    }

    protected function getRootClassName(): string
    {
        return ArticleRoot::class;
    }

    public function createFilterForArticleType(int $articleType, array $overrides): ArticleRoot
    {
        $configuration = $this->settings['articleType'][$articleType] ?? null;
        if ($configuration === null) {
            $filter = new ArticleRoot([], $this->node);
            $filter->setArticleType($articleType);
            return $filter;
        }

        $filter = $this->createFilter($configuration, $overrides);
        if (!($filter instanceof ArticleRoot)) {
            throw new InvalidObjectException('Object is expected to be ArticleRoot');
        }

        $filter->setArticleType($articleType);
        return $filter;
    }
}
