<?php

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Poi\Neos\Service;

use Neos\Flow\Configuration\ConfigurationManager;
use Newland\NeosCommon\Service\AbstractRegionService;

class RegionService extends AbstractRegionService
{
    protected function regionsAvailable(ConfigurationManager $configurationManager): array
    {
        return (array) $configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Poi.Neos.regions.available'
        );
    }

    protected function regionsEnabled(ConfigurationManager $configurationManager): array
    {
        return (array) $configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Poi.Neos.regions.enabled'
        );
    }
}
