<?php
namespace Newland\Toubiz\Poi\Neos\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

class ArticleHelper implements ProtectedContextAwareInterface
{

    /**
     * @var ArticleRepository
     * @Flow\Inject()
     */
    protected $articleRepository;

    public function findByIdentifier(string $identifier): ?Article
    {
        if (!$identifier) {
            return null;
        }
        return $this->articleRepository->findByIdentifier($identifier);
    }

    /**
     * @param string $methodName
     * @return bool
     */
    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'findByIdentifier';
    }
}
