<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Link;

use Neos\Flow\Mvc\ActionRequest;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;

class ArticleFilterViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'a';

    public function initializeArguments(): void
    {
        $this->registerUniversalTagAttributes();
        $this->registerArgument('query', 'array', 'The search query array', true);
    }

    public function render(): string
    {
        /** @var ActionRequest $request */
        $request = $this->controllerContext->getRequest();

        $uri = (clone $this->controllerContext->getUriBuilder())
            ->reset()
            ->setFormat('html')
            ->uriFor(
                'show',
                [
                    'node' => $request->getInternalArgument('__node'),
                    'query' => $this->arguments['query'],
                ],
                'FilteredLists',
                'Newland.Toubiz.Poi.Neos'
            );

        $this->tag->setContent($this->renderChildren());
        $this->tag->addAttribute('href', $uri);

        return $this->tag->render();
    }
}
