<?php

namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter;

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\Poi\Neos\ViewHelpers\Filter\Controller\TagController;

class TagWidgetViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var TagController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('queryParameters', 'array', 'The query parameters');
        $this->registerArgument('node', 'object', 'The current node');
        $this->registerArgument('queryOverride', 'array', 'The query override');
    }

    public function render(): string
    {
        $response = $this->initiateSubRequest();
        return (string) $response->getBody();
    }
}
