<?php
namespace Newland\Toubiz\Poi\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Poi\Neos\Domain\Model\Tag;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

class TagRepository
{

    public function findOneByCategory(Category $category): Tag
    {
        $tag = new Tag(
            TopicRepository::TYPE_CATEGORY . ':' . $category->getPersistenceObjectIdentifier(),
            $category->getTitle()
        );

        return $tag;
    }

    public function findOneByProperty(string $property)
    {
        return $this->findOneByBooleanAttribute('properties:' . $property);
    }

    public function findOneByLabel(string $label): Tag
    {
        return $this->findOneByBooleanAttribute('labels:' . $label);
    }

    public function findOneByRange(string $attribute, array $attributeValues): Tag
    {
        $tag = new Tag(
            TopicRepository::TYPE_ATTRIBUTE . ':' . $attribute,
            '',
            $attribute,
            $attributeValues['min'] . ';' . $attributeValues['max'],
            Tag::TYPE_RANGE
        );
        return $tag;
    }

    public function findOneByValue(string $attribute, string $value): Tag
    {
        $tag = new Tag(
            TopicRepository::TYPE_ATTRIBUTE . ':' . $attribute . ':' . $value,
            '',
            $attribute,
            $value,
            Tag::TYPE_STRING
        );

        return $tag;
    }

    private function findOneByBooleanAttribute(string $attribute) : Tag
    {
        $tag = new Tag(
            TopicRepository::TYPE_ATTRIBUTE . ':' . $attribute,
            '',
            $attribute,
            true,
            Tag::TYPE_BOOLEAN
        );

        return $tag;
    }
}
