import { asyncComponent, loadVue } from './vue';

export function initializeVueApp(element) {
    loadVue().then(Vue => {
        new Vue({
            el: element,
            components: {
                TbOpeningTimesLinePreview: asyncComponent(() => import('./components/opening-times-line-preview.vue')),
            },
            data: { open: false },
            methods: {
                toggleOpenState() {
                    this.open = !this.open;
                },
            },
        });
    });
}
