const path = require('path');
const CleanWebpackPlugin = require('clean-webpack-plugin');
const VueLoaderPlugin = require('vue-loader/lib/plugin');
const CompressionPlugin = require('compression-webpack-plugin');

module.exports = {
    mode: 'production',

    entry: {
        index: './Resources/Private/Scripts/index.js'
    },

    output: {
        path: path.resolve(__dirname, 'Resources/Public/Scripts'),
        filename: '[name].bundle.js',
        chunkFilename: '[chunkhash].chunk.js',
        publicPath: '/_Resources/Static/Packages/Newland.Toubiz.Poi.Neos/Scripts/',

        /*
         * see https://github.com/neos/neos-development-collection/issues/2104
         * for why we need to set library option here (actually we don't need it
         * in this styleguide because it isn't part of a Neos project but we keep
         * it to have similar config across styleguides).
         */
        library: 'Newland.Toubiz.Poi.Neos',
        libraryTarget: 'umd',
    },

    module: {
        rules: [
            {
                test: /.jsx?$/,
                exclude: /node_modules/,
                loader: 'babel-loader',
            },
            {
                test: /.vue$/,
                exclude: /node_modules/,
                loader: 'vue-loader',
            }
        ]
    },

    plugins: [
        new CleanWebpackPlugin(),
        new VueLoaderPlugin(),
        new CompressionPlugin(),
    ],

    resolve: {
        alias: {
            'vue$': 'vue/dist/vue.esm.js'
        }
    }
};