<?php
namespace Newland\Toubiz\Poi\Neos\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Mvc\Controller\ActionController;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;
use Neos\Flow\Annotations as Flow;

class ArticleBackendController extends ActionController
{
    /**
     * @var AttributeRepository
     * @Flow\Inject()
     */
    protected $attributeRepository;

    public function indexAction()
    {
        $popularTags = $this->attributeRepository
            ->getMostPopularTagsByArticleType(ArticleConstants::TYPE_ATTRACTION, 25);

        $configuredTags = $this->settings['tags']['articleTypes'][ArticleConstants::TYPE_ATTRACTION] ?? [];

        array_walk(
            $popularTags,
            function (array &$tag) use ($configuredTags) {
                $tag['configured'] = in_array('tag:' . $tag['data'], $configuredTags, true);
            }
        );

        $this->view->assignMultiple(
            [
                'articleTypes' => [
                    'poi' => [
                        'popularTags' => $popularTags,
                    ],
                ],
            ]
        );
    }
}
