<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

/**
 * Target node view helper.
 *
 * Returns the target node for a given article. Each article is assigned a
 * main category, for which a page node that is being responsible for said
 * type exists.
 */
class TargetNodeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * This may also return null in case the article is not present anymore.
     *
     * @param Article|null $article
     * @return Node|null
     */
    public function render(Article $article = null)
    {
        if (!$article) {
            return;
        }

        $node = $this->controllerContext->getRequest()->getInternalArgument('__node');
        $site = $node->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.Poi.Neos:List][articleType *= "' . $article->getMainType() . '"]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }
}
