<?php
namespace Newland\Toubiz\Poi\Neos\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;

/**
 * Abstract action controller.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractActionController extends ActionController
{
    /**
     * @var Node The current node.
     */
    protected $node;

    /**
     * @var Node The target node for linking records.
     */
    protected $targetNode;

    /**
     * @var array
     */
    protected $properties;

    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Action initializer.
     *
     * Called before the called action. This may be called
     * manually inside an action that is working outside of
     * the default node/context, like an AJAX action.
     *
     * @return void
     */
    protected function initializeAction(Node $node = null)
    {
        if ($node) {
            $this->node = $node;
        } else {
            $this->node = $this->request->getInternalArgument('__node');
        }

        if (!$this->node) {
            return;
        }

        $this->properties = $this->node->getProperties();
        $site = $this->node->getContext()->getCurrentSiteNode();

        if (array_key_exists('articleType', $this->properties)) {
            $targetNodeQuery = new FlowQuery([$site]);
            $this->targetNode = $targetNodeQuery->find('[instanceof Newland.Toubiz.Poi.Neos:List][articleType *= "' . $this->properties['articleType'] . '"]')
                                                ->parents('[instanceof Neos.NodeTypes:Page]')
                                                ->get(0);
        }
    }

    /**
     * View initializer.
     *
     * Called before a view is rendered.
     *
     * @param ViewInterface $view
     * @return void
     */
    protected function initializeView(ViewInterface $view)
    {
        $view->assignMultiple([
            'configuration' => $this->configuration,
            'node' => $this->node,
            'targetNode' => $this->targetNode
        ]);
    }
}
