<?php
namespace Newland\Toubiz\Packages\Neos\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

class PackageHelper implements ProtectedContextAwareInterface
{

    /**
     * @var PackageRepository
     * @Flow\Inject()
     */
    protected $packageRepository;

    public function findByIdentifier(string $identifier): ?Package
    {
        if (!$identifier) {
            return null;
        }
        return $this->packageRepository->findByIdentifier($identifier);
    }

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName)
    {
        return $methodName === 'findByIdentifier';
    }
}
