<?php
namespace Newland\Toubiz\Packages\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class PackageViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Packages.Neos.targetUri")
     * @var string
     */
    protected $targetUri;

    public function initializeArguments()
    {
        $this->registerTagAttribute('class', 'string', 'Class of the element');
        parent::initializeArguments();
    }

    public function render(Package $package): string
    {
        if ($this->targetUri) {
            $href = $this->urlTemplate(
                $this->targetUri,
                [
                    ':id' => $package->getOriginalId(),
                    ':client' => $package->getClient(),
                ]
            );

            $this->tag->addAttribute('href', $href);
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }

    private function urlTemplate(string $url, array $replacements): string
    {
        return str_replace(
            array_keys($replacements),
            array_map('urlencode', array_values($replacements)),
            $url
        );
    }
}
