<?php declare(strict_types=1);

namespace Newland\Toubiz\Packages\Neos\Tests\Unit\DataSource;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Packages\Neos\DataSource\PackagesDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\PackageFactory;

class PackageDataSourceTest extends FunctionalTestCase
{
    use InteractsWithNodes;
    protected static $testablePersistenceEnabled = true;

    /** @var PackageFactory */
    protected $factory;

    /** @var PackagesDataSource */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new PackageFactory($this->objectManager);
        $this->subject = $this->objectManager->get(PackagesDataSource::class);
    }

    public function testListsAllAvailablePackages(): void
    {
        $this->factory->createMultiple(5);
        $this->assertCount(5, $this->subject->getData(null, [ ]));
    }

    public function testLimitsResultsToLangaugeIfPassedAsArgument(): void
    {
        $this->factory->createMultiple(3, [ 'language' => 'de' ]);
        $this->factory->createMultiple(2, [ 'language' => 'en' ]);
        $this->assertCount(2, $this->subject->getData(null, [ 'language' => 'en' ]));
    }


    public function testLimitsResultsToLangaugeIfPassedAsNodeDimension(): void
    {
        $this->factory->createMultiple(3, [ 'language' => 'fr' ]);
        $this->factory->createMultiple(2, [ 'language' => 'en' ]);

        $node = $this->initializeNode('/sites/foo', null, null, [ ], 'fr');
        $this->assertCount(3, $this->subject->getData($node, [ ]));
    }

    public function testDoesNotTaintRepository(): void
    {
        $repository = $this->objectManager->get(PackageRepository::class);
        $repository->setLanguage('de');

        $this->subject->getData(null, [ 'language' => 'fr' ]);

        $this->assertEquals('de', $repository->getLanguage());
    }
}
