<?php
namespace Newland\Toubiz\Packages\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class PackageViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var string
     */
    protected $tagName = 'a';

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerUniversalTagAttributes();
        $this->registerArgument('package', Package::class, 'The package to link to', false, null);
    }

    public function render(): string
    {
        $package = $this->arguments['package'];
        if ($package) {
            $this->tag->addAttribute('href', $package->getDetailUri() ?? '#');
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
