<?php declare(strict_types=1);

namespace Newland\Toubiz\Packages\Neos\LinkHandler;

use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;

class PackageRecord extends Record
{
    /** @var Package */
    protected $package;

    public function __construct(Package $package)
    {
        $this->package = $package;
        $this->id = $package->getPersistenceObjectIdentifier();
        $this->title = $package->getName();
    }

    public function getPackage(): Package
    {
        return $this->package;
    }
}
