<?php
namespace Newland\Toubiz\Packages\Neos\Controller;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Filter\PackageFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

/**
 * @Flow\Scope("singleton")
 */
class PackageController extends AbstractActionController
{

    /**
     * @var array
     */
    protected $properties;

    /**
     * @var PackageRepository
     * @Flow\Inject
     */
    protected $packageRepository;

    public function teaserAction()
    {
        $this->view->assignMultiple(
            [
                'node' =>  $this->node,
                'package' => $this->getPackage(),
            ]
        );
    }

    public function teaserListAction()
    {
        $filter = new PackageFilter();
        $filter->setCurrentSite($this->currentSite->getNodeName());

        if (array_key_exists('recordLimit', $this->properties)) {
            $filter->setLimit($this->properties['recordLimit']);
        }

        $packages = $this->packageRepository->findByFilter($filter);

        $enableSwiper = $this->properties['displayStyle'] === 'swiper';

        $this->view->assignMultiple(
            [
                'packages' => $packages,
                'enableSwiper' => $enableSwiper,
            ]
        );
    }

    /**
     * @return Package|null
     */
    private function getPackage()
    {
        if (array_key_exists('packageId', $this->properties)) {
            return $this->packageRepository->findByIdentifier($this->properties['packageId']);
        }
        return null;
    }
}
