<?php
namespace Newland\Toubiz\Packages\Neos\ViewHelpers\Link;


use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class PackageViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Packages.Neos.targetUri")
     * @var string
     */
    protected $lodgingUri;

    public function initializeArguments()
    {
        $this->registerTagAttribute('class', 'string', 'Class of the element');
        parent::initializeArguments();
    }

    /**
     * @param Package $package
     * @return string
     */
    public function render(Package $package): string
    {
        if ($this->lodgingUri) {
            $href = str_replace(
                ':id',
                $package->getOriginalId(),
                $this->lodgingUri
            );
            $this->tag->addAttribute('href', $href);
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }


}