<?php
namespace Newland\Toubiz\Packages\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

/**
 * @Flow\Scope("singleton")
 */
class PackagesDataSource extends AbstractDataSource
{
    static protected $identifier = 'newland-toubiz-packages-neos-packages';

    /**
     * @var PackageRepository
     * @Flow\Inject
     */
    protected $packageRepository;

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments)
    {
        return $this->packageRepository
            ->createQueryBuilder('package')
            ->select([
                'package.name as label',
                'package.Persistence_Object_Identifier as value'
            ])
            ->getQuery()
            ->execute();
    }
}
