<?php
namespace Newland\Toubiz\Packages\Neos\Controller;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

/**
 * @Flow\Scope("singleton")
 */
class PackageController extends ActionController
{

    /**
     * @var array
     */
    protected $properties;

    /**
     * @var PackageRepository
     * @Flow\Inject
     */
    protected $packageRepository;

    public function initializeAction()
    {
        /** @var NodeInterface $node */
        $node = $this->request->getInternalArgument('__node');
        if ($node && $node->getProperties()) {
            $this->properties = $node->getProperties();
        }
    }


    public function teaserAction()
    {
        $this->view->assignMultiple([
            'node' =>  $this->request->getInternalArgument('__node'),
            'package' => $this->getPackage()
        ]);
    }

    /**
     * @return Package|null
     */
    private function getPackage()
    {
        if (array_key_exists('packageId', $this->properties)) {
            return $this->packageRepository->findByIdentifier($this->properties['packageId']);
        }
        return null;
    }
}
