<?php declare(strict_types=1);

namespace Newland\Toubiz\Packages\Tests\Unit\LinkHandler;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Packages\Neos\LinkHandler\PackageRecord;
use Newland\Toubiz\Sync\Neos\Tests\Factory\PackageFactory;

class PackageRecordTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    public function testFillsIdFromPackageIdentifier(): void
    {
        $package = (new PackageFactory($this->objectManager))->create();
        $this->assertEquals(
            $package->getPersistenceObjectIdentifier(),
            (new PackageRecord($package))->getId()
        );
    }

    public function testFillsTitleFromPackageTitle(): void
    {
        $package = (new PackageFactory($this->objectManager))->create();
        $this->assertEquals(
            $package->getName(),
            (new PackageRecord($package))->getTitle()
        );
    }

}
