<?php
namespace Newland\Toubiz\Packages\Neos\ViewHelpers\Format;

use Newland\Toubiz\Sync\Neos\Enum\Currency;

/**
 * Pre-configured version of the `f:format.currency` view helper that sets
 * default values for arguments based on the currency symbol passed.
 */
class CurrencyViewHelper extends \Neos\FluidAdaptor\ViewHelpers\Format\CurrencyViewHelper
{

    /**
     * Mapping of ISO 4217 currency keys to `f:format.currency` configuration options.
     * The `DEFAULT` configuration is applied to all currencies.
     *
     * @var array
     */
    protected static $currencyConfiguration = [
        'DEFAULT' => [
            'prependCurrency' => false,
            'decimals' => 2,
        ],
        Currency::EURO => [
            'currencySign' => '€',
            'decimalSeparator' => ',',
            'thousandsSeparator' => '.',
        ],
        Currency::SWISS_FRANC => [
            'currencySign' => 'CHF',
            'decimalSeparator' => '.',
            'thousandsSeparator' => '\'',
        ],
        Currency::BRITISH_POUND => [
            'currencySign' => '£',
            'decimalSeparator' => '.',
            'thousandsSeparator' => ',',
        ],
        Currency::US_DOLLAR => [
            'currencySign' => '$',
            'decimalSeparator' => '.',
            'thousandsSeparator' => ',',
            'prependCurrency' => true,
        ]
    ];

    /**
     * @return string
     * @throws \Neos\FluidAdaptor\Core\ViewHelper\Exception
     * @throws \Neos\FluidAdaptor\Core\ViewHelper\Exception\InvalidVariableException
     */
    public function render(): string
    {
        $currencyCode = $this->arguments['currencyCode'];

        if (array_key_exists($currencyCode, static::$currencyConfiguration)) {
            $this->applyArgumentDefaults(static::$currencyConfiguration[$currencyCode]);
        }
        $this->applyArgumentDefaults(static::$currencyConfiguration['DEFAULT']);

        if (!$this->arguments['currencySign']) {
            $this->arguments['currencySign'] = $this->arguments['currencyCode'];
        }

        return parent::render();
    }

    private function applyArgumentDefaults(array $defaults): void
    {
        foreach ($defaults as $key => $value) {
            if (!array_key_exists($key, $this->argumentDefinitions)) {
                continue;
            }

            if ($this->arguments[$key] === $this->argumentDefinitions[$key]->getDefaultValue()) {
                $this->arguments[$key] = $value;
            }
        }
    }
}
