<?php
namespace Newland\Toubiz\Packages\Neos\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Packages\Neos\Service\PackageUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

class PackageHelper implements ProtectedContextAwareInterface
{

    /**
     * @var PackageRepository
     * @Flow\Inject()
     */
    protected $packageRepository;

    /**
     * @var PackageUrlService
     * @Flow\Inject()
     */
    protected $packageUrlService;

    public function findByIdentifier(?string $identifier): ?Package
    {
        if (!$identifier) {
            return null;
        }
        return $this->packageRepository->findByIdentifier($identifier);
    }

    /**
     * @param Package|string $package
     */
    public function url($package): ?string
    {
        if (\is_string($package)) {
            $package = $this->packageRepository->findByIdentifier($package);
        }

        if (!($package instanceof Package)) {
            return '#';
        }

        return $this->packageUrlService->generateUrl($package);
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'findByIdentifier' || $methodName === 'url';
    }
}
