<?php
namespace Newland\Toubiz\Packages\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Packages\Neos\Service\PackageUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Neos\Flow\Annotations as Flow;

class PackageViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var PackageUrlService
     * @Flow\Inject()
     */
    protected $packageUrlService;

    protected $tagName = 'a';

    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        parent::initializeArguments();
    }

    public function render(?Package $package): string
    {
        if ($package) {
            $this->tag->addAttribute(
                'href',
                $this->packageUrlService->generateUrl($package) ?? '#'
            );
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
