<?php declare(strict_types=1);

namespace Newland\Toubiz\Packages\Neos\Tests\Unit;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Sync\Neos\Domain\Model\Package;
use Newland\Toubiz\Sync\Neos\Tests\Factory\PackageFactory;

class PackageHelperTest extends FunctionalTestCase
{
    use CompilesFusion, InteractsWithNodes;
    protected static $testablePersistenceEnabled = true;

    /** @var NodeInterface */
    protected $node;

    public function setUp(): void
    {
        parent::setUp();
        $site = $this->initializeSite('foo');
        $this->node = $this->initializeNode('/sites/foo', null, $site);
    }

    public function testReturnsNothingIfNoPackageFound(): void
    {
        $result = $this->compileFusion(
            $this->node,
            '${Newland.Toubiz.Package.findByIdentifier(q(node).property("package")).getName()}'
        );

        $this->assertEmpty($result);
    }

    public function testFetchesPackageById(): void
    {
        $package = (new PackageFactory($this->objectManager))->create();
        $this->node->setProperty('package', $package->getPersistenceObjectIdentifier());

        $result = $this->compileFusion(
            $this->node,
            '${Newland.Toubiz.Package.findByIdentifier(q(node).property("package"))}'
        );

        $this->assertInstanceOf(Package::class, $result);
    }

}
