<?php
namespace Newland\Toubiz\Packages\Neos\DataSource;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\PackageRepository;

/**
 * @Flow\Scope("singleton")
 */
class PackagesDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-packages-neos-packages';

    /**
     * @var PackageRepository
     * @Flow\Inject()
     */
    protected $packageRepository;

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments)
    {
        return $this->packageRepository->withLanguage(
            $this->language($node, $arguments),
            function () {
                return $this->packageRepository
                    ->createQueryBuilder('package')
                    ->select(
                        [
                            'package.name as label',
                            'package.Persistence_Object_Identifier as value',
                        ]
                    )
                    ->getQuery()
                    ->execute();
            }
        );
    }

    private function language(?NodeInterface $node, array $arguments): ?string
    {
        if (array_key_exists('language', $arguments)) {
            return (string) $arguments['language'];
        }

        if ($node !== null) {
            return $node->getDimensions()['language'][0] ?? null;
        }

        return null;
    }
}
