<?php
namespace Newland\Toubiz\Offer\Neos\Eel\Helper;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Offer\Neos\Service\OfferUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;

class OfferHelper implements ProtectedContextAwareInterface
{

    /**
     * @var OfferRepository
     * @Flow\Inject()
     */
    protected $offerRepository;

    /**
     * @var OfferUrlService
     * @Flow\Inject()
     */
    protected $offerUrlService;

    public function findByIdentifier(string $identifier): ?Offer
    {
        if (!$identifier) {
            return null;
        }
        return $this->offerRepository->findByIdentifier($identifier);
    }

    /**
     * @param Offer|string $offer
     */
    public function url($offer): ?string
    {
        if (\is_string($offer)) {
            $offer = $this->offerRepository->findByIdentifier($offer);
        }

        if (!($offer instanceof Offer)) {
            return '#';
        }

        return $this->offerUrlService->generateUrl($offer);
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'findByIdentifier' || $methodName === 'url';
    }
}
