<?php
namespace Newland\Toubiz\Offer\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Filter\CategoryFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;

/**
 * @Flow\Scope("singleton")
 */
class OffersDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-offer-neos-offers';

    /**
     * @var OfferRepository
     * @Flow\Inject()
     */
    protected $offerRepository;

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $this->setLanguageOnRepository($node, $arguments);

        return $this->offerRepository
            ->createQueryBuilder('offer')
            ->select([
                'offer.Persistence_Object_Identifier as value',
                'offer.name as label',
            ])
            ->getQuery()
            ->execute();
    }

    private function setLanguageOnRepository(?NodeInterface $node, array $arguments): void
    {
        if (array_key_exists('language', $arguments)) {
            $this->offerRepository->setLanguage($arguments['language']);
            return;
        }

        if ($node !== null) {
            $language = $node->getDimensions()['language'][0] ?? null;
            if ($language) {
                $this->offerRepository->setLanguage($language);
                return;
            }
        }
    }
}
