<?php
namespace Newland\Toubiz\Offer\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @Flow\Scope("singleton")
 */
class OfferViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var string
     */
    protected $tagName = 'a';

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerUniversalTagAttributes();
        $this->registerArgument('offer', Offer::class, 'Offer to link to', false, null);
    }

    public function render(): string
    {
        $offer = $this->arguments['offer'];
        if ($offer !== null) {
            $this->tag->addAttribute('href', $offer->getDetailUri() ?? '#');
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
