<?php
namespace Newland\Toubiz\Offer\Neos\ViewHelpers\Format;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

class DurationToHoursViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('minutes', 'integer', 'Number of minutes to convert', false, null);
        $this->registerArgument('separator', 'string', 'Separator to use between hours & minutes', false, ':');
    }

    public function render(): string
    {
        $minutes = $this->arguments['minutes'] ?: (int) $this->renderChildren();
        $hours = floor($minutes / 60);
        $minutes -= $hours * 60;
        return $hours . $this->arguments['separator'] . $minutes;
    }
}
