<?php declare(strict_types=1);

namespace Newland\Toubiz\Offer\Neos\LinkHandler;

use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

class OfferRecord extends Record
{
    /** @var Offer */
    protected $offer;

    public function __construct(Offer $offer)
    {
        $this->offer = $offer;
        $this->id = (string) $offer->getPersistenceObjectIdentifier();
        $this->title = $offer->getName();
    }

    public function getOffer(): Offer
    {
        return $this->offer;
    }
}
