<?php declare(strict_types=1);

namespace Newland\Toubiz\Offer\Neos\LinkHandler;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\NeosCommon\LinkHandler\Handler\AbstractLinkHandler;
use Newland\Toubiz\Offer\Neos\Service\OfferUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class OfferLinkHandler extends AbstractLinkHandler
{

    /**
     * @var OfferRepository
     * @Flow\Inject()
     */
    protected $offerRepository;

    /**
     * @var OfferUrlService
     * @Flow\Inject()
     */
    protected $offerUrlService;

    public function findByIdentifier(string $recordIdentifier): ?Record
    {
        $offer = $this->offerRepository->findByIdentifier($recordIdentifier);
        if (!$offer) {
            return null;
        }

        return new OfferRecord($offer);
    }

    public function findBySearchTerm(string $searchTerm): array
    {
        $offers = $this->offerRepository
            ->createQueryBuilder('offer')
            ->where('offer.name LIKE :term')
            ->setParameter('term', sprintf('%%%s%%', $searchTerm))
            ->setMaxResults(10)
            ->getQuery()
            ->execute();

        return array_map(
            function (Offer $offer) {
                return new OfferRecord($offer);
            },
            $offers
        );
    }

    public function generateRecordLink(
        Record $record,
        ControllerContext $controllerContext,
        NodeInterface $contextNode,
        bool $absolute
    ): ?string {
        if (!($record instanceof OfferRecord)) {
            $record = $this->findByIdentifier($record->getId());
            if (!$record) {
                return null;
            }
        }

        return $this->offerUrlService->generateUrl($record->getOffer());
    }
}
