<?php
namespace Newland\Toubiz\Offer\Neos\Controller;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ActionController;
use Newland\Toubiz\Sync\Neos\Domain\Filter\OfferFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;
use Neos\Flow\Annotations as Flow;

class OfferController extends ActionController
{

    /**
     * @var OfferRepository
     * @Flow\Inject
     */
    protected $offerRepository;

    /**
     * @var array
     */
    protected $properties;

    public function teaserAction()
    {
        $filter = $this->getFilter($this->properties);
        $this->view->assignMultiple([
            'offers' => $this->offerRepository->findByFilter($filter),
        ]);
    }

    public function teaserListAction()
    {
        $filter = $this->getFilter($this->properties);
        $this->view->assignMultiple([
            'offers' => $this->offerRepository->findByFilter($filter),
            'enableSwiper' => $this->properties['displayStyle'] === 'swiper',
        ]);
    }

    public function initializeAction(NodeInterface $node = null)
    {
        $node = $node ?: $this->request->getInternalArgument('__node');
        $this->properties = $node->getProperties();
    }

    private function getFilter(array $properties): OfferFilter
    {
        $filter = new OfferFilter();

        if (array_key_exists('offer', $properties)) {
            $filter->setOffers([ $properties['offer'] ]);
        }

        if (array_key_exists('recordLimit', $properties)) {
            $filter->setLimit($properties['recordLimit']);
        }

        return $filter;
    }
}
