<?php
namespace Newland\Toubiz\Offer\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Offer\Neos\Service\OfferUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @Flow\Scope("singleton")
 */
class OfferViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var OfferUrlService
     * @Flow\Inject()
     */
    protected $offerUrlService;

    protected $tagName = 'a';

    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        parent::initializeArguments();
    }

    public function render(?Offer $offer): string
    {
        if ($offer !== null) {
            $this->tag->addAttribute(
                'href',
                $this->offerUrlService->generateUrl($offer) ?? '#'
            );
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
