<?php
namespace Newland\Toubiz\Offer\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @Flow\Scope("singleton")
 */
class OfferViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Offer.Neos.targetUri")
     * @var string
     */
    protected $targetUri;

    public function initializeArguments()
    {
        $this->registerTagAttribute('class', 'string', 'Class of the element');
        parent::initializeArguments();
    }

    /**
     * @param Offer $offer
     * @return string
     */
    public function render(Offer $offer): string
    {
        if ($this->targetUri) {
            $href = str_replace(
                ':id',
                $offer->getOriginalId(),
                $this->targetUri
            );
            $this->tag->addAttribute('href', $href);
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
