<?php declare(strict_types=1);

namespace Newland\Toubiz\Offer\Tests\Unit\LinkHandler;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Offer\Neos\LinkHandler\OfferRecord;
use Newland\Toubiz\Sync\Neos\Tests\Factory\OfferFactory;

class OfferRecordTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    public function testFillsIdFromPackageIdentifier(): void
    {
        $offer = (new OfferFactory($this->objectManager))->create();
        $this->assertEquals(
            $offer->getPersistenceObjectIdentifier(),
            (new OfferRecord($offer))->getId()
        );
    }

    public function testFillsTitleFromPackageTitle(): void
    {
        $offer = (new OfferFactory($this->objectManager))->create();
        $this->assertEquals(
            $offer->getName(),
            (new OfferRecord($offer))->getTitle()
        );
    }


}
