<?php
namespace Newland\Toubiz\Offer\Neos\Controller;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\OfferFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;
use Neos\Flow\Annotations as Flow;

class OfferController extends ActionController
{

    /**
     * @var OfferRepository
     * @Flow\Inject
     */
    protected $offerRepository;

    /**
     * @var array
     */
    protected $properties;

    protected function initializeView(ViewInterface $view)
    {
        $view->assign('node', $this->request->getInternalArgument('__node'));
    }

    public function teaserAction(): void
    {
        $filter = $this->getFilter($this->properties);
        $this->view->assignMultiple(
            [
                'offer' => $this->offerRepository->findOneByFilter($filter),
            ]
        );
    }

    public function teaserListAction(): void
    {
        $filter = $this->getFilter($this->properties);
        $sorted = $this->offerRepository->getSorted(
            $filter,
            'PersistenceObjectIdentifier',
            $filter->getOffers()
        );
        $this->view->assignMultiple(
            [
                'offers' => $sorted,
                'enableSwiper' => $this->properties['displayStyle'] === 'swiper',
            ]
        );
    }

    public function initializeAction(NodeInterface $node = null): void
    {
        /** @var NodeInterface $node */
        $node = $node ?: $this->request->getInternalArgument('__node');
        $this->properties = (array) $node->getProperties();
    }

    private function getFilter(array $properties): OfferFilter
    {
        $filter = new OfferFilter();

        if (\is_array($properties['offers'] ?? null)) {
            $filter->setOffers($properties['offers']);
        } elseif (\is_string($properties['offer'] ?? null)) {
            $filter->setOffers([ $properties['offer'] ]);
        }

        if (array_key_exists('recordLimit', $properties)) {
            $filter->setLimit($properties['recordLimit']);
        }

        return $filter;
    }
}
