<?php
namespace Newland\Toubiz\Offer\Neos\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;
use Newland\Toubiz\Sync\Neos\Domain\Repository\OfferRepository;

class OfferHelper implements ProtectedContextAwareInterface
{

    /**
     * @var OfferRepository
     * @Flow\Inject()
     */
    protected $offerRepository;

    /**
     * @param string $identifier
     * @return Offer|null
     */
    public function findByIdentifier(string $identifier)
    {
        if (!$identifier) {
            return null;
        }
        return $this->offerRepository->findByIdentifier($identifier);
    }

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName)
    {
        return $methodName === 'findByIdentifier';
    }
}
