# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [unreleased]
### Added
- Added marker nodetype Selected Pages: 'Newland.Toubiz.Map.Neos:Map.Markers.SelectedPages'
  This adds a select dropdown of all available pages and uses the toubizMap inspector-tab settings to display the pages, if selected.


## [1.14.5] - 2019-11-20
### Changed
- Selecting a filter item to be open by default now sets the default filter to only show that item
  when loading the page.
- The filter item markup now does not depend on target-enhancement anymore.

### Fixed
- Fixed newly added nodes under maps not being recognized on their first publish.

### Actions required
- Be sure to update your toubiz-styleguide to `1.6.2` or higher in order to have a working map filter item menu.

## [1.14.0] - 2019-09-17
### Changed
- This update contains a major rewrite of the map plugin. Maps under this version work in a completely
  different way: Instead of defining a single node containing a single filter, maps now are more modular,
  allowing users to fine-tune contents. Because of this radically different approach none of the previous
  maps can be easily and automatically migrated.
- Adjust existing `img` tags to use lazy loading.

### Action Required
- All maps have to be rebuilt by hand using the new node types.
    - See `README.md` and confluence articles for reference.
- Google maps api keys must be moved from `Newland.Toubiz.Map.Neos.services.map.apiKey.*` to
  `Newland.Toubiz.Map.Neos.apiKeys.*.googleMaps`
    - If you only have a single site configured you can migrate the key to `Newland.Toubiz.Map.Neos.apiKeys.default.googleMaps`
    - If you are using one neos instance for multiple sites and have a apiKey per site then you can configure
      the API keys in `Newland.Toubiz.Map.Neos.apiKeys.sites.{SITE_NODENAME}.googleMaps`
- Markup of map filter menu was adjusted. If your project contained style overrides for this, check if they still
  work like before.

## [1.11.3] - 2019-07-04
### Fixed
- Fix `map:buildarticlecache` not rebuilding cache with correct identifier.

## [1.10.4] - 2019-06-07
### Fixed
- Fixed map configuration parsing of keys for static maps

## [1.10.0] - 2019-06-07
### Fixed
- Fixed typing issues preventing Location node from being displayed

## [1.5.3] - 2019-05-08
### Added
- Moved NodeRepository to NeosCommon
- Support multiple API keys for map services.

## [1.5.2] - 2019-04-04
### Added
- Map cache is now dimension aware

### Fixed
- Dependency to toubiz-poi is now only soft dependency. This means that it will have features 
  related to toubiz-poi if that package is also installed but will not also install toubiz-poi.

## [1.5.1] - 2019-03-08
- No functional changes

## [1.5.0] - 2019-03-08
### Changed 
- All Maps plugins are located in one group in the backend interface
- Now uses target-enhancement 2.0 compatible markup

### Fixed
- Added missing hotel category mapping ids
