<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\ViewHelpers;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use TYPO3Fluid\Fluid\Core\ViewHelper\TagBuilder;

class IconViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'svg';

    public function initializeArguments(): void
    {
        $this->registerArgument('id', 'string', 'Id of the icon to display.', true);
    }

    public function render(): string
    {
        $this->tag->addAttribute('class', 'c-icon');
        $this->tag->setContent($this->getUseTag());
        return $this->tag->render();
    }

    private function getUseTag(): string
    {
        $use = new TagBuilder('use');
        $use->addAttribute('xlink:href', sprintf('#%s', $this->arguments['id']));
        return $use->render();
    }
}
