<?php

namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Neos\Flow\Annotations as Flow;

class ArticleTypeDataSource extends AbstractDataSource
{
    public static $identifier = 'newland-toubiz-map-neos-article-types';

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $data = [];
        foreach (ArticleConstants::ALL_TYPES as $type) {
            $data[] = [
                'value' => $type,
                'label' => $this->translator->translateById(
                    sprintf('mainType.%d', $type),
                    [],
                    null,
                    null,
                    'Models/Article',
                    'Newland.Toubiz.Poi.Neos'
                )
            ];
        }
        return $data;
    }
}
