<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Pagination;

class InvalidPageException extends \InvalidArgumentException
{
    public static function create(int $pageNumber, int $maxPage): self
    {
        return new self(sprintf(
            'Invalid page number %s. Must be between 1 and %s',
            $pageNumber,
            $maxPage
        ));
    }
}
